/* 
   Qtechknow Creator Kit: Circuit 3: LightSensor
 
   The Qduino reads how much light is in the room -
   connect the light sensor to pin A0
 
   created by Qtechknow
   made on 8 July 15
   
 */
#include "Qduino.h"
#include "Wire.h"

qduino q;  // initialize the library

int sensorValue;   // variable to store light value

void setup() {
  
  q.setup();
  
  Serial.begin(9600);  // start Serial communication
  
  while(!Serial); // wait until Serial monitor is opened

}

void loop() {
  
  // assign the variable to the pin value
  sensorValue = analogRead(A0);

  int val = map(sensorValue, 32, 930, 0, 100);
  // convert the value to easily readable numbers
  
  Serial.println(val);  // print on the Serial monitor
  delay(100);  // wait 1/10 of a second for next reading
}
